
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_BLOQ_EST_NF_SAI_IT_QT_IT_ZERO]'))
DROP TRIGGER [dbo].[TRG_BLOQ_EST_NF_SAI_IT_QT_IT_ZERO]
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220107
'Job.................:  
'Nome................: TRG_BLOQ_EST_NF_SAI_IT_QT_IT_ZERO
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........:  20220106
'Dt Ult Alteraco....:	20220113
'Alterado por........: Marcos barros
'Criado por..........: Shirlene Campos
'=======================================================================================
FARMAGOI-26104 - 202201131045 -
 */


CREATE TRIGGER [dbo].[TRG_BLOQ_EST_NF_SAI_IT_QT_IT_ZERO] ON [dbo].[EST_NF_SAI_IT] 
FOR INSERT AS
BEGIN
        IF EXISTS
                (SELECT i.CD_PROD
                FROM    INSERTED i
                        INNER JOIN EST_NF_SAI
                        ON      i.CD_EMP    = EST_NF_SAI.CD_EMP
                        AND     i.CD_FILIAL = EST_NF_SAI.CD_FILIAL
                        AND     i.CD_NF     = EST_NF_SAI.CD_NF
                        INNER JOIN GLB_MOV_OP
                        ON      EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
                        INNER JOIN EST_PROD
                        ON      i.CD_EMP  = EST_PROD.CD_EMP
                        AND     i.CD_PROD = EST_PROD.CD_PROD
                WHERE   i.QT_IT          <=0
                AND (  GLB_MOV_OP.TP_MOV   <> 25
                        AND     GLB_MOV_OP.TP_MOV              <> 58
                        AND     GLB_MOV_OP.FLAG_MOV_OP_NFE_CPL <> 1  )
                AND   ISNULL(EST_PROD.FLAG_RESSARCIMENTO, 0) = 0 
                )
                BEGIN
                        RAISERROR ('Produto com quantidade zerada.',16, 1);
                        RETURN;
                END
        END ;